
;CodeVisionAVR C Compiler V2.05.0 Professional
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega328
;Program type             : Application
;Clock frequency          : 16,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 512 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : No
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega328
	#pragma AVRPART MEMORY PROG_FLASH 32768
	#pragma AVRPART MEMORY EEPROM 1024
	#pragma AVRPART MEMORY INT_SRAM SIZE 2303
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU EECR=0x1F
	.EQU EEDR=0x20
	.EQU EEARL=0x21
	.EQU EEARH=0x22
	.EQU SPSR=0x2D
	.EQU SPDR=0x2E
	.EQU SMCR=0x33
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU WDTCSR=0x60
	.EQU UCSR0A=0xC0
	.EQU UDR0=0xC6
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU GPIOR0=0x1E

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0100
	.EQU __SRAM_END=0x08FF
	.EQU __DSTACK_SIZE=0x0200
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _Mode=R3
	.DEF _NumberF=R4
	.DEF _rx_wr_index0=R2
	.DEF _rx_rd_index0=R7
	.DEF _rx_counter0=R6
	.DEF _AmountTimers=R9

;GPIOR0 INITIALIZATION VALUE
	.EQU __GPIOR0_INIT=0x00

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer0_ovf_isr
	JMP  0x00
	JMP  _usart_rx_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

_0x63:
	.DB  0x0
_0x2020060:
	.DB  0x1
_0x2020000:
	.DB  0x2D,0x4E,0x41,0x4E,0x0,0x49,0x4E,0x46
	.DB  0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x09
	.DW  _0x63*2

	.DW  0x01
	.DW  __seed_G101
	.DW  _0x2020060*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	WDR
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	STS  WDTCSR,R31
	STS  WDTCSR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,LOW(__SRAM_START)
	LDI  R27,HIGH(__SRAM_START)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;GPIOR0 INITIALIZATION
	LDI  R30,__GPIOR0_INIT
	OUT  GPIOR0,R30

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x300

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.0 Professional
;Project : vna328
;Version : 1.0
;Date    : 14.10.2013
;Author  : RA4NAL
;Company : Home
;
;Chip type               : ATmega328
;Program type            : Application
;AVR Core Clock frequency: 16,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 512
;*****************************************************/
;//=================  =====================
;#define PORT_DDS PORTC  //  PORTC  DDS
;#define FQUP     3      // PORTC.3 connected to AD9851 device select pin
;#define WCLK     4      // PORTC.4 connected to AD9851 clock pin
;#define D7       5      // PORTC.5 connected to AD9851 D7 (serial data) pin
;#define PORT_RLE PORTD  //  PORTD  rele  RESET
;#define RESET    2      // PORTD.2 connected to RESET AD9851
;#define RELE     3      // PORTD.3 connected to rele
;// PC1 - ADC1 - 
;// PC2 - ADC2 - 
;// AREF
;//===================================================
;#define PowerDown 0x04  //    Power down AD9851
;#define Normal 0x01     //     AD9851
;#define TimeRX 500      //    USART ~500 
;// FTW = (Fout*2^32)180
;#define MinFrq 11930470 // FTW  min freq = 0,5 Mhz
;
;#include <mega328.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif
;#include <delay.h>
;#include <stdio.h>      // Standard Input/Output functions
;#include <stdlib.h>     //  
;#include <ctype.h>      //  
;#include <iobits.h>     // SETBIT, CLRBIT
;
;// ============= Global variables ==============
;//    
;unsigned char Mode;       //  
;unsigned long int StartF; //  
;unsigned int NumberF;     // - 
;unsigned long int StepF;  //  
;
;bit bit_rx0_end;          //   UART 
;bit bit_rx0_error;        //  UART
;
;// USART Receiver buffer
;#define RX_BUFFER_SIZE0 32
;unsigned char rx_buffer0[RX_BUFFER_SIZE0];
;unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;
;
;//  
;#include "timers.h"       //  
;
;SoftTimer timer1;         //   
;
;#include "timers.c"       //  
;//***************************************************************************
;//  File........: Timers.
;//
;//  Author(s)...: Pashgan    chipenable.ru
;//
;//  Target(s)...:  ,     
;//
;//  Compiler....: CodeVision 2.04
;//
;//  Description.:      
;//
;//  Revisions...:  1.0
;//
;//  20.10.09        1.0       Pashgan
;//  22.10.09        1.0       Pashgan
;//***************************************************************************
;
;// 
;unsigned char AmountTimers = 0;
;
;//   
;SoftTimer* SoftTimers[MAX_TIMERS];
;
;void CreateTimer(SoftTimer *CurSoftTimer, unsigned int time, unsigned int period , enum StateTimer state, void (*pFunc)(void))
; 0000 003E {

	.CSEG
_CreateTimer:
;  SoftTimers[AmountTimers] = CurSoftTimer;
;	*CurSoftTimer -> Y+7
;	time -> Y+5
;	period -> Y+3
;	state -> Y+2
;	*pFunc -> Y+0
	MOV  R30,R9
	CALL SUBOPT_0x0
	ADD  R30,R26
	ADC  R31,R27
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	STD  Z+0,R26
	STD  Z+1,R27
;  CurSoftTimer->time = time;
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ST   X+,R30
	ST   X,R31
;  CurSoftTimer->period = period;
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	__PUTW1SNS 7,2
;  CurSoftTimer->state = state;
	LDD  R30,Y+2
	__PUTB1SNS 7,4
;  CurSoftTimer->pFunc = pFunc;
	LD   R30,Y
	LDD  R31,Y+1
	__PUTW1SNS 7,5
;  AmountTimers++;
	INC  R9
;}
	ADIW R28,9
	RET
;
;void CheckTimer(void)
;{
_CheckTimer:
;unsigned char i;
;  for(i = 0; i < AmountTimers; i++){
	ST   -Y,R17
;	i -> R17
	LDI  R17,LOW(0)
_0x4:
	CP   R17,R9
	BRLO PC+3
	JMP _0x5
;    if (SoftTimers[i]->state == ACTIVE){
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	LDD  R26,Z+4
	CPI  R26,LOW(0x1)
	BREQ PC+3
	JMP _0x6
;      if (SoftTimers[i]->time == 0){
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	MOVW R26,R30
	CALL __GETW1P
	SBIW R30,0
	BRNE _0x7
;        SoftTimers[i]->pFunc();
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	ADIW R30,5
	MOVW R26,R30
	LD   R30,X+
	LD   R31,X+
	ICALL
;        if (SoftTimers[i]->period != 0) SoftTimers[i]->time = (SoftTimers[i]->period-1);
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	ADIW R30,2
	MOVW R26,R30
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x8
	MOV  R30,R17
	CALL SUBOPT_0x0
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	ADIW R30,2
	MOVW R26,R30
	CALL __GETW1P
	SBIW R30,1
	MOVW R26,R0
	ST   X+,R30
	ST   X,R31
;        else SoftTimers[i]->state = DONE;
	RJMP _0x9
_0x8:
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	ADIW R30,4
	LDI  R26,LOW(2)
	STD  Z+0,R26
;      }
_0x9:
;      else
	RJMP _0xA
_0x7:
;        (SoftTimers[i]->time)--;
	MOV  R30,R17
	CALL SUBOPT_0x0
	CALL SUBOPT_0x1
	MOVW R26,R30
	LD   R30,X+
	LD   R31,X+
	SBIW R30,1
	ST   -X,R31
	ST   -X,R30
;    }
_0xA:
;  }
_0x6:
	SUBI R17,-1
	RJMP _0x4
_0x5:
;}
	RJMP _0x20A0003
;
;void RestartTimer(SoftTimer *timer, unsigned int time)
;{
_RestartTimer:
;   timer->time = time;
;	*timer -> Y+2
;	time -> Y+0
	LD   R30,Y
	LDD  R31,Y+1
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ST   X+,R30
	ST   X,R31
;   timer->state = ACTIVE;
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,4
	LDI  R30,LOW(1)
	ST   X,R30
;}
	ADIW R28,4
	RET
;
;#include "interrupt328.c" // 
;//************* Interrupt TMR0, USART mega328 **********
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 003F {
_timer0_ovf_isr:
	CALL SUBOPT_0x2
;  CheckTimer();
	RCALL _CheckTimer
;}
	RJMP _0x62
;
;// USART0 Receiver interrupt service routine
;interrupt [USART_RXC] void usart_rx_isr(void)
;{
_usart_rx_isr:
	CALL SUBOPT_0x2
;unsigned char data;
;data=UCSR0A;                //  
	ST   -Y,R17
;	data -> R17
	LDS  R17,192
;data=UDR0;
	LDS  R17,198
;
;if ((data == 0x0D)||(isdigit(data) ==1)) //  0x0D                    //  
	CPI  R17,13
	BREQ _0xC
	CALL SUBOPT_0x3
	BRNE _0xB
_0xC:
;   {
;   if (rx_wr_index0 ==0)
	TST  R2
	BRNE _0xE
;     {
;     RestartTimer(&timer1, TimeRX);    //   
	LDI  R30,LOW(_timer1)
	LDI  R31,HIGH(_timer1)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _RestartTimer
;     }
;   rx_buffer0[rx_wr_index0++]=data;
_0xE:
	MOV  R30,R2
	INC  R2
	LDI  R31,0
	SUBI R30,LOW(-_rx_buffer0)
	SBCI R31,HIGH(-_rx_buffer0)
	ST   Z,R17
;   if (rx_wr_index0 == RX_BUFFER_SIZE0) rx_wr_index0=0;
	LDI  R30,LOW(32)
	CP   R30,R2
	BRNE _0xF
	CLR  R2
;   if (++rx_counter0 == RX_BUFFER_SIZE0)
_0xF:
	INC  R6
	LDI  R30,LOW(32)
	CP   R30,R6
	BRNE _0x10
;      {
;      rx_counter0=0;
	CLR  R6
;      bit_rx0_error=1;
	SBI  0x1E,1
;      }
;   };
_0x10:
_0xB:
;}
	LD   R17,Y+
_0x62:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;
;#include "usart.c"        // / UART, ADC
;//=============== USART0, ADC ======================
;
;// Time out  USART
;void TimeOut(void)
; 0000 0040 {
_TimeOut:
;  bit_rx0_end = 1;
	SBI  0x1E,0
;}
	RET
;
;// Get a character from the USART0 Receiver buffer
;//     RX,   ,  ==0
;char getRX(void)
;{
_getRX:
;unsigned char data;
;
;if (rx_counter0 !=0)
	ST   -Y,R17
;	data -> R17
	TST  R6
	BREQ _0x15
;  {
;   data=rx_buffer0[rx_rd_index0++];
	MOV  R30,R7
	INC  R7
	LDI  R31,0
	SUBI R30,LOW(-_rx_buffer0)
	SBCI R31,HIGH(-_rx_buffer0)
	LD   R17,Z
;   if (rx_rd_index0 == RX_BUFFER_SIZE0) rx_rd_index0=0;
	LDI  R30,LOW(32)
	CP   R30,R7
	BRNE _0x16
	CLR  R7
;   #asm("cli")
_0x16:
	cli
;   --rx_counter0;
	DEC  R6
;   #asm("sei")
	sei
;  }
;else data=0;
	RJMP _0x17
_0x15:
	LDI  R17,LOW(0)
;return data;
_0x17:
	MOV  R30,R17
_0x20A0003:
	LD   R17,Y+
	RET
;}
;
;//   UART
;void USART_Transmit( unsigned char data )
;{
_USART_Transmit:
;/* Wait for empty transmit buffer */
;while ( !( UCSR0A & (1<<UDRE0)) );
;	data -> Y+0
_0x18:
	LDS  R30,192
	ANDI R30,LOW(0x20)
	BREQ _0x18
;/* Put data into buffer, sends the data */
;UDR0 = data;
	LD   R30,Y
	STS  198,R30
;}
	ADIW R28,1
	RET
;
;// ============== / ADC ==================
;// Read the AD conversion result
;//  -     Vref (0 =   Vref)
;
;unsigned int read_adc(unsigned char adc_input, unsigned char adc_vref)
;{
_read_adc:
;ADMUX=(adc_input & 0x1f) | (adc_vref & 0xff);
;	adc_input -> Y+1
;	adc_vref -> Y+0
	LDD  R30,Y+1
	ANDI R30,LOW(0x1F)
	MOV  R26,R30
	LD   R30,Y
	OR   R30,R26
	STS  124,R30
;if (adc_input & 0x20) ADCSRB |= 0x08;
	LDD  R30,Y+1
	ANDI R30,LOW(0x20)
	BREQ _0x1B
	LDS  R30,123
	ORI  R30,8
	RJMP _0x60
;else ADCSRB &= 0xf7;
_0x1B:
	LDS  R30,123
	ANDI R30,0XF7
_0x60:
	STS  123,R30
;// Delay needed for the stabilization of the ADC input voltage
;delay_us(10);
	__DELAY_USB 53
;// Start the AD conversion
;ADCSRA|=0x40;
	LDS  R30,122
	ORI  R30,0x40
	STS  122,R30
;// Wait for the AD conversion to complete
;while ((ADCSRA & 0x10)==0);
_0x1D:
	LDS  R30,122
	ANDI R30,LOW(0x10)
	BREQ _0x1D
;ADCSRA|=0x10;
	LDS  R30,122
	ORI  R30,0x10
	STS  122,R30
;return ADCW;
	LDS  R30,120
	LDS  R31,120+1
	RJMP _0x20A0001
;}
;
;#include "decoder.c"      // /    
;// ==========     UART ==============
;//   ,  
;
;char DecodeCom (void)
; 0000 0041 {
_DecodeCom:
;unsigned char data, i, err=0,  Param[11];
;
;if (bit_rx0_error !=0) return (2);   //(1);          //  
	SBIW R28,11
	CALL __SAVELOCR4
;	data -> R17
;	i -> R16
;	err -> R19
;	Param -> Y+4
	LDI  R19,0
	SBIS 0x1E,1
	RJMP _0x20
	LDI  R30,LOW(2)
	RJMP _0x20A0002
;
;data = getRX();                           // 1- 
_0x20:
	RCALL _getRX
	MOV  R17,R30
;switch (data)
	MOV  R30,R17
;  {
;  case '0': Mode = 0; break;
	CPI  R30,LOW(0x30)
	BRNE _0x24
	CLR  R3
	RJMP _0x23
;  case '1': Mode = 1; break;
_0x24:
	CPI  R30,LOW(0x31)
	BRNE _0x26
	LDI  R30,LOW(1)
	MOV  R3,R30
	RJMP _0x23
;  default: err = 1;
_0x26:
	LDI  R19,LOW(1)
;  }
_0x23:
;
;data = getRX();                           // 
	CALL SUBOPT_0x4
;if  (data !=0x0D) err = 1;
	BREQ _0x27
	LDI  R19,LOW(1)
;if  (err != 0)  return (err);               // , 
_0x27:
	CPI  R19,0
	BREQ _0x28
	MOV  R30,R19
	RJMP _0x20A0002
;
;for (i = 0; i <= 10; i++)                  // 2- 
_0x28:
	LDI  R16,LOW(0)
_0x2A:
	CPI  R16,11
	BRSH _0x2B
;  {
;  data = getRX();
	CALL SUBOPT_0x4
;  if (data == 0x0D) break;                  //  
	BREQ _0x2B
;  if (isdigit(data) ==1) Param[i] = data;    // ,  
	CALL SUBOPT_0x3
	BRNE _0x2D
	CALL SUBOPT_0x5
	ADD  R30,R26
	ADC  R31,R27
	ST   Z,R17
;     else  err = 1;                         // 
	RJMP _0x2E
_0x2D:
	LDI  R19,LOW(1)
;  }
_0x2E:
	SUBI R16,-1
	RJMP _0x2A
_0x2B:
;
;if  ((i==0) | (i>10))  err = 1;              //  
	CALL SUBOPT_0x6
	LDI  R30,LOW(10)
	CALL __GTB12U
	OR   R30,R0
	BREQ _0x2F
	LDI  R19,LOW(1)
;Param[i] = 0;                                //  
_0x2F:
	CALL SUBOPT_0x5
	CALL SUBOPT_0x7
;if  (err != 0)  return (err);                // , 
	BREQ _0x30
	MOV  R30,R19
	RJMP _0x20A0002
;
;StartF = atol (Param);                       //   unsigned long int
_0x30:
	CALL SUBOPT_0x8
	CALL _atol
	CALL SUBOPT_0x9
;
;for (i = 0; i <= 5; i++)                   // 3- 
	LDI  R16,LOW(0)
_0x32:
	CPI  R16,6
	BRSH _0x33
;  {
;  data = getRX();
	CALL SUBOPT_0x4
;  if (data == 0x0D) break;                  //  
	BREQ _0x33
;  if (isdigit(data) ==1) Param[i] = data;    // ,  
	CALL SUBOPT_0x3
	BRNE _0x35
	CALL SUBOPT_0x5
	ADD  R30,R26
	ADC  R31,R27
	ST   Z,R17
;     else  err = 1;                         // 
	RJMP _0x36
_0x35:
	LDI  R19,LOW(1)
;  }
_0x36:
	SUBI R16,-1
	RJMP _0x32
_0x33:
;if  ((i==0) | (i>5))  err = 1;                 //  
	CALL SUBOPT_0x6
	LDI  R30,LOW(5)
	CALL __GTB12U
	OR   R30,R0
	BREQ _0x37
	LDI  R19,LOW(1)
;Param[i] = 0;                                //  
_0x37:
	CALL SUBOPT_0x5
	CALL SUBOPT_0x7
;if  (err != 0)  return (err);                // , 
	BREQ _0x38
	MOV  R30,R19
	RJMP _0x20A0002
;
;NumberF = atoi (Param);                      //   unsigned int
_0x38:
	CALL SUBOPT_0x8
	CALL _atoi
	MOVW R4,R30
;
;for (i = 0; i <= 10; i++)                  // 4- 
	LDI  R16,LOW(0)
_0x3A:
	CPI  R16,11
	BRSH _0x3B
;  {
;  data = getRX();
	CALL SUBOPT_0x4
;  if (data == 0x0D) break;                  //  
	BREQ _0x3B
;  if (isdigit(data) ==1) Param[i] = data;    // ,  
	CALL SUBOPT_0x3
	BRNE _0x3D
	CALL SUBOPT_0x5
	ADD  R30,R26
	ADC  R31,R27
	ST   Z,R17
;     else  err = 1;                         // 
	RJMP _0x3E
_0x3D:
	LDI  R19,LOW(1)
;  }
_0x3E:
	SUBI R16,-1
	RJMP _0x3A
_0x3B:
;if  ((i==0) || (i>10))  err = 1;                //  
	CPI  R16,0
	BREQ _0x40
	CPI  R16,11
	BRLO _0x3F
_0x40:
	LDI  R19,LOW(1)
;Param[i] = 0;                                //  
_0x3F:
	CALL SUBOPT_0x5
	CALL SUBOPT_0x7
;if  (err != 0)  return (err);                // , 
	BREQ _0x42
	MOV  R30,R19
	RJMP _0x20A0002
;
;StepF = atol (Param);                        //   unsigned long int
_0x42:
	CALL SUBOPT_0x8
	CALL _atol
	STS  _StepF,R30
	STS  _StepF+1,R31
	STS  _StepF+2,R22
	STS  _StepF+3,R23
;return (0);
	LDI  R30,LOW(0)
_0x20A0002:
	CALL __LOADLOCR4
	ADIW R28,15
	RET
;}
;
;// ==============   SPI =================
;void TransmitDDS (unsigned char cData)
;{
_TransmitDDS:
;unsigned char i;
;
;for (i=0; i<8; i++)
	ST   -Y,R17
;	cData -> Y+1
;	i -> R17
	LDI  R17,LOW(0)
_0x44:
	CPI  R17,8
	BRSH _0x45
;  { if ((cData & 0x01)==0) CLRBIT(PORT_DDS,D7)
	LDD  R30,Y+1
	ANDI R30,LOW(0x1)
	BRNE _0x46
	CBI  0x8,5
;      else SETBIT(PORT_DDS,D7);
	RJMP _0x47
_0x46:
	SBI  0x8,5
_0x47:
;    delay_us(3);
	CALL SUBOPT_0xA
;    SETBIT(PORT_DDS,WCLK);
;    delay_us(3);
;    CLRBIT(PORT_DDS,WCLK);
;    cData>>=1;
	LDD  R30,Y+1
	LSR  R30
	STD  Y+1,R30
;  }
	SUBI R17,-1
	RJMP _0x44
_0x45:
;}
	LDD  R17,Y+0
_0x20A0001:
	ADIW R28,2
	RET
;
;// ==========     AD9851 ===========
;
;void Load9851 (void)
;{
_Load9851:
;unsigned char i, j, m;
;unsigned long int freq;
;
;freq=StartF;               //  
	SBIW R28,4
	CALL __SAVELOCR4
;	i -> R17
;	j -> R16
;	m -> R19
;	freq -> Y+4
	LDS  R30,_StartF
	LDS  R31,_StartF+1
	LDS  R22,_StartF+2
	LDS  R23,_StartF+3
	__PUTD1S 4
;m=Mode;                    //  
	MOV  R19,R3
;for (i=0; i<4; i++)
	LDI  R17,LOW(0)
_0x49:
	CPI  R17,4
	BRSH _0x4A
;  {
;  j = (char)freq;
	LDD  R16,Y+4
;  TransmitDDS(j);
	ST   -Y,R16
	RCALL _TransmitDDS
;  freq>>=8;
	__GETD2S 4
	LDI  R30,LOW(8)
	CALL __LSRD12
	__PUTD1S 4
;  }
	SUBI R17,-1
	RJMP _0x49
_0x4A:
;  TransmitDDS(m);               //  
	ST   -Y,R19
	RCALL _TransmitDDS
;  SETBIT(PORT_DDS,FQUP);
	SBI  0x8,3
;  delay_us(3);
	__DELAY_USB 16
;  CLRBIT(PORT_DDS,FQUP);
	CBI  0x8,3
;}
	CALL __LOADLOCR4
	ADIW R28,8
	RET
;
;
;
;void main(void)
; 0000 0044 {
_main:
; 0000 0045 // ================== Local variables ==============
; 0000 0046 unsigned char Temp;
; 0000 0047 unsigned int intTemp;
; 0000 0048 unsigned int adcamp;
; 0000 0049 unsigned int adcphs;
; 0000 004A 
; 0000 004B #include "initSFR328.c"     //  SFR mega328
;//  SFR ATmega2560
;
;// Crystal Oscillator division factor: 1
;#pragma optsize-
;CLKPR=0x80;
	SBIW R28,2
;	Temp -> R17
;	intTemp -> R18,R19
;	adcamp -> R20,R21
;	adcphs -> Y+0
	LDI  R30,LOW(128)
	STS  97,R30
;CLKPR=0x00;
	LDI  R30,LOW(0)
	STS  97,R30
;#ifdef _OPTIMIZE_SIZE_
;#pragma optsize+
;#endif
;
;// Input/Output Ports initialization
;// Port B initialization PB5=0 (Led off)
;// Func7=In Func6=In Func5=Out Func4=In Func3=In Func2=In Func1=In Func0=In
;// State7=T State6=T State5=0 State4=T State3=T State2=T State1=T State0=T
;PORTB=0x00;
	OUT  0x5,R30
;DDRB=0x20;
	LDI  R30,LOW(32)
	OUT  0x4,R30
;
;// Port C initialization
;// Func6=In Func5=Out Func4=Out Func3=Out Func2=In Func1=In Func0=In
;// State6=T State5=0 State4=0 State3=0 State2=T State1=T State0=T
;PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x8,R30
;DDRC=0x38;
	LDI  R30,LOW(56)
	OUT  0x7,R30
;
;// Port D initialization
;// Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=Out Func1=In Func0=In
;// State7=T State6=T State5=T State4=T State3=0 State2=0 State1=T State0=T
;PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
;DDRD=0x0C;
	LDI  R30,LOW(12)
	OUT  0xA,R30
;
;// Timer/Counter 0 initialization
;// Clock source: System Clock
;// Clock value: 250,000 kHz
;// Mode: Normal top=0xFF
;// OC0A output: Disconnected
;// OC0B output: Disconnected
;TCCR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0x24,R30
;TCCR0B=0x03;
	LDI  R30,LOW(3)
	OUT  0x25,R30
;TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x26,R30
;OCR0A=0x00;
	OUT  0x27,R30
;OCR0B=0x00;
	OUT  0x28,R30
;
;// Timer/Counter 1 initialization
;// Clock source: System Clock
;// Clock value: Timer1 Stopped
;// Mode: Normal top=0xFFFF
;// OC1A output: Discon.
;// OC1B output: Discon.
;// Noise Canceler: Off
;// Input Capture on Falling Edge
;// Timer1 Overflow Interrupt: Off
;// Input Capture Interrupt: Off
;// Compare A Match Interrupt: Off
;// Compare B Match Interrupt: Off
;TCCR1A=0x00;
	STS  128,R30
;TCCR1B=0x00;
	STS  129,R30
;TCNT1H=0x00;
	STS  133,R30
;TCNT1L=0x00;
	STS  132,R30
;ICR1H=0x00;
	STS  135,R30
;ICR1L=0x00;
	STS  134,R30
;OCR1AH=0x00;
	STS  137,R30
;OCR1AL=0x00;
	STS  136,R30
;OCR1BH=0x00;
	STS  139,R30
;OCR1BL=0x00;
	STS  138,R30
;
;// Timer/Counter 2 initialization
;// Clock source: System Clock
;// Clock value: Timer2 Stopped
;// Mode: Normal top=0xFF
;// OC2A output: Disconnected
;// OC2B output: Disconnected
;ASSR=0x00;
	STS  182,R30
;TCCR2A=0x00;
	STS  176,R30
;TCCR2B=0x00;
	STS  177,R30
;TCNT2=0x00;
	STS  178,R30
;OCR2A=0x00;
	STS  179,R30
;OCR2B=0x00;
	STS  180,R30
;
;// External Interrupt(s) initialization
;// INT0: Off
;// INT1: Off
;// Interrupt on any change on pins PCINT0-7: Off
;// Interrupt on any change on pins PCINT8-14: Off
;// Interrupt on any change on pins PCINT16-23: Off
;EICRA=0x00;
	STS  105,R30
;EIMSK=0x00;
	OUT  0x1D,R30
;PCICR=0x00;
	STS  104,R30
;
;// Timer/Counter 0 Interrupt(s) initialization
;TIMSK0=0x01;
	LDI  R30,LOW(1)
	STS  110,R30
;
;// Timer/Counter 1 Interrupt(s) initialization
;TIMSK1=0x00;
	LDI  R30,LOW(0)
	STS  111,R30
;
;// Timer/Counter 2 Interrupt(s) initialization
;TIMSK2=0x00;
	STS  112,R30
;
;// USART initialization
;// Communication Parameters: 8 Data, 1 Stop, No Parity
;// USART Receiver: On
;// USART Transmitter: On
;// USART0 Mode: Asynchronous
;// USART Baud Rate: 115200 (Double Speed Mode)
;UCSR0A=0x22;
	LDI  R30,LOW(34)
	STS  192,R30
;UCSR0B=0x98;
	LDI  R30,LOW(152)
	STS  193,R30
;UCSR0C=0x06;
	LDI  R30,LOW(6)
	STS  194,R30
;UBRR0H=0x00;
	LDI  R30,LOW(0)
	STS  197,R30
;UBRR0L=0x10;
	LDI  R30,LOW(16)
	STS  196,R30
;
;// Analog Comparator initialization
;// Analog Comparator: Off
;// Analog Comparator Input Capture by Timer/Counter 1: Off
;ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x30,R30
;ADCSRB=0x00;
	LDI  R30,LOW(0)
	STS  123,R30
;DIDR1=0x00;
	STS  127,R30
;
;// ADC initialization
;// ADC Clock frequency: 125,000 kHz
;// ADC Auto Trigger Source: ADC Stopped
;// Digital input buffers on ADC0: Off, ADC1: Off, ADC2: Off, ADC3: On
;// ADC4: On, ADC5: On
;DIDR0=0x07;
	LDI  R30,LOW(7)
	STS  126,R30
;ADCSRA=0x87;
	LDI  R30,LOW(135)
	STS  122,R30
;
;// SPI initialization
;// SPI disabled
;SPCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x2C,R30
;SPSR=0x00;
	OUT  0x2D,R30
;
;// TWI initialization
;// TWI disabled
;TWCR=0x00;
	STS  188,R30
;
; 0000 004C 
; 0000 004D //  AD9851  serial mode
; 0000 004E delay_ms(50);
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0000 004F SETBIT(PORT_RLE,RESET);
	SBI  0xB,2
; 0000 0050 delay_us(3);
	__DELAY_USB 16
; 0000 0051 CLRBIT(PORT_RLE,RESET);
	CBI  0xB,2
; 0000 0052 delay_us(3);
	CALL SUBOPT_0xA
; 0000 0053 SETBIT(PORT_DDS,WCLK);
; 0000 0054 delay_us(3);
; 0000 0055 CLRBIT(PORT_DDS,WCLK);
; 0000 0056 delay_us(3);
	__DELAY_USB 16
; 0000 0057 SETBIT(PORT_DDS,FQUP);
	SBI  0x8,3
; 0000 0058 delay_us(3);
	__DELAY_USB 16
; 0000 0059 CLRBIT(PORT_DDS,FQUP);
	CBI  0x8,3
; 0000 005A StartF=0;                    //  
	LDI  R30,LOW(0)
	STS  _StartF,R30
	STS  _StartF+1,R30
	STS  _StartF+2,R30
	STS  _StartF+3,R30
; 0000 005B Mode=PowerDown;              // 
	LDI  R30,LOW(4)
	MOV  R3,R30
; 0000 005C Load9851();
	RCALL _Load9851
; 0000 005D 
; 0000 005E //   UART
; 0000 005F   rx_wr_index0 = 0;
	CLR  R2
; 0000 0060   rx_rd_index0 = 0;
	CLR  R7
; 0000 0061   rx_counter0 = 0;
	CLR  R6
; 0000 0062   bit_rx0_error = 0;         //   
	CBI  0x1E,1
; 0000 0063   bit_rx0_end = 0;           //    USART
	CBI  0x1E,0
; 0000 0064 
; 0000 0065 Temp=UDR0;                   //  UART
	LDS  R17,198
; 0000 0066 Temp=UDR0;                   // -------------
	LDS  R17,198
; 0000 0067 
; 0000 0068 //    UART,    
; 0000 0069 CreateTimer(&timer1, 0, 0, IDLE, TimeOut);
	LDI  R30,LOW(_timer1)
	LDI  R31,HIGH(_timer1)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R30
	LDI  R30,LOW(_TimeOut)
	LDI  R31,HIGH(_TimeOut)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _CreateTimer
; 0000 006A 
; 0000 006B #asm("sei")                  // Global enable interrupts
	sei
; 0000 006C 
; 0000 006D // =================   ======================
; 0000 006E while (1)
_0x4F:
; 0000 006F       {
; 0000 0070       if (bit_rx0_end == 1)           // time out  
	SBIS 0x1E,0
	RJMP _0x52
; 0000 0071         {
; 0000 0072         Temp = DecodeCom ();          //   
	RCALL _DecodeCom
	MOV  R17,R30
; 0000 0073 //    UART
; 0000 0074           #asm("cli")
	cli
; 0000 0075           rx_wr_index0 = 0;
	CLR  R2
; 0000 0076           rx_rd_index0 = 0;
	CLR  R7
; 0000 0077           rx_counter0 = 0;
	CLR  R6
; 0000 0078           bit_rx0_error = 0;         //   
	CBI  0x1E,1
; 0000 0079           bit_rx0_end = 0;           //    USART
	CBI  0x1E,0
; 0000 007A           #asm("sei")
	sei
; 0000 007B         if ((Temp==0) & (NumberF!=0)) //  
	MOV  R26,R17
	LDI  R30,LOW(0)
	CALL __EQB12
	MOV  R0,R30
	MOVW R26,R4
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL __NEW12
	AND  R30,R0
	BRNE PC+3
	JMP _0x57
; 0000 007C           {
; 0000 007D           if (Mode == 0) CLRBIT(PORT_RLE,RELE)   // .  . 
	TST  R3
	BRNE _0x58
	CBI  0xB,3
; 0000 007E             else SETBIT(PORT_RLE,RELE);
	RJMP _0x59
_0x58:
	SBI  0xB,3
_0x59:
; 0000 007F //  
; 0000 0080           for (intTemp=0; intTemp < NumberF; intTemp++)
	__GETWRN 18,19,0
_0x5B:
	__CPWRR 18,19,4,5
	BRSH _0x5C
; 0000 0081             {
; 0000 0082              if (StartF > MinFrq)  Mode = Normal;   // F > 0,5 mhz
	CALL SUBOPT_0xB
	__CPD2N 0xB60B67
	BRLO _0x5D
	LDI  R30,LOW(1)
	RJMP _0x61
; 0000 0083                 else Mode = PowerDown;  // F < 0,5 mhz, Power Down
_0x5D:
	LDI  R30,LOW(4)
_0x61:
	MOV  R3,R30
; 0000 0084             Load9851();               //  9851
	RCALL _Load9851
; 0000 0085             delay_us(1000);           //  1000 
	__DELAY_USW 4000
; 0000 0086             adcamp = read_adc(1,0);   //  , vref
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _read_adc
	MOVW R20,R30
; 0000 0087             adcphs = read_adc(2,0);   //  , vref
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _read_adc
	CALL SUBOPT_0xC
; 0000 0088             Temp = (unsigned char)adcphs; //  
; 0000 0089             USART_Transmit(Temp);     // LSB
; 0000 008A             adcphs = adcphs>>8;
	LDD  R30,Y+1
	ANDI R31,HIGH(0x0)
	CALL SUBOPT_0xC
; 0000 008B             Temp = (unsigned char)adcphs;
; 0000 008C             USART_Transmit(Temp);     // MSB
; 0000 008D             Temp = (unsigned char)adcamp;  //  
	MOV  R17,R20
; 0000 008E             USART_Transmit(Temp);     // LSB
	ST   -Y,R17
	RCALL _USART_Transmit
; 0000 008F             adcamp = adcamp>>8;
	MOV  R20,R21
	CLR  R21
; 0000 0090             Temp = (unsigned char)adcamp;
	MOV  R17,R20
; 0000 0091             USART_Transmit(Temp);     // MSB
	ST   -Y,R17
	RCALL _USART_Transmit
; 0000 0092             StartF = StartF+StepF;    //  
	LDS  R30,_StepF
	LDS  R31,_StepF+1
	LDS  R22,_StepF+2
	LDS  R23,_StepF+3
	CALL SUBOPT_0xB
	CALL __ADDD12
	CALL SUBOPT_0x9
; 0000 0093             }
	__ADDWRN 18,19,1
	RJMP _0x5B
_0x5C:
; 0000 0094           }
; 0000 0095         }
_0x57:
; 0000 0096       }
_0x52:
	RJMP _0x4F
; 0000 0097 }
_0x5F:
	RJMP _0x5F
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif

	.CSEG

	.CSEG
_atoi:
   	ldd  r27,y+1
   	ld   r26,y
__atoi0:
   	ld   r30,x
	ST   -Y,R30
	CALL _isspace
   	tst  r30
   	breq __atoi1
   	adiw r26,1
   	rjmp __atoi0
__atoi1:
   	clt
   	ld   r30,x
   	cpi  r30,'-'
   	brne __atoi2
   	set
   	rjmp __atoi3
__atoi2:
   	cpi  r30,'+'
   	brne __atoi4
__atoi3:
   	adiw r26,1
__atoi4:
   	clr  r22
   	clr  r23
__atoi5:
   	ld   r30,x
	ST   -Y,R30
	CALL _isdigit
   	tst  r30
   	breq __atoi6
   	movw r30,r22
   	lsl  r22
   	rol  r23
   	lsl  r22
   	rol  r23
   	add  r22,r30
   	adc  r23,r31
   	lsl  r22
   	rol  r23
   	ld   r30,x+
   	clr  r31
   	subi r30,'0'
   	add  r22,r30
   	adc  r23,r31
   	rjmp __atoi5
__atoi6:
   	movw r30,r22
   	brtc __atoi7
   	com  r30
   	com  r31
   	adiw r30,1
__atoi7:
   	adiw r28,2
   	ret
_atol:
    ldd  r27,y+1
    ld   r26,y
__atol0:
    ld   r30,x
	ST   -Y,R30
	CALL _isspace
    tst  r30
    breq __atol1
    adiw r26,1
    rjmp __atol0
__atol1:
    clt
    ld   r30,x
    cpi  r30,'-'
    brne __atol2
    set
    rjmp __atol3
__atol2:
    cpi  r30,'+'
    brne __atol4
__atol3:
    adiw r26,1
__atol4:
    clr  r0
    clr  r1
    clr  r24
    clr  r25
__atol5:
    ld   r30,x
	ST   -Y,R30
	CALL _isdigit
    tst  r30
    breq __atol6
    movw r30,r0
    movw r22,r24
    rcall __atol8
    rcall __atol8
    add  r0,r30
    adc  r1,r31
    adc  r24,r22
    adc  r25,r23
    rcall __atol8
    ld   r30,x+
    clr  r31
    subi r30,'0'
    add  r0,r30
    adc  r1,r31
    adc  r24,r31
    adc  r25,r31
    rjmp __atol5
__atol6:
    movw r30,r0
    movw r22,r24
    brtc __atol7
    com  r30
    com  r31
    com  r22
    com  r23
    clr  r24
    adiw r30,1
    adc  r22,r24
    adc  r23,r24
__atol7:
    adiw r28,2
    ret

__atol8:
    lsl  r0
    rol  r1
    rol  r24
    rol  r25
    ret

	.DSEG

	.CSEG

	.CSEG
_isdigit:
    ldi  r30,1
    ld   r31,y+
    cpi  r31,'0'
    brlo isdigit0
    cpi  r31,'9'+1
    brlo isdigit1
isdigit0:
    clr  r30
isdigit1:
    ret
_isspace:
    ldi  r30,1
    ld   r31,y+
    cpi  r31,' '
    breq isspace1
    cpi  r31,9
    brlo isspace0
    cpi  r31,13+1
    brlo isspace1
isspace0:
    clr  r30
isspace1:
    ret

	.CSEG

	.CSEG

	.DSEG
_StartF:
	.BYTE 0x4
_StepF:
	.BYTE 0x4
_rx_buffer0:
	.BYTE 0x20
_timer1:
	.BYTE 0x7
_SoftTimers:
	.BYTE 0x2
__seed_G101:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0x0:
	LDI  R26,LOW(_SoftTimers)
	LDI  R27,HIGH(_SoftTimers)
	LDI  R31,0
	LSL  R30
	ROL  R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x1:
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x2:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x3:
	ST   -Y,R17
	CALL _isdigit
	CPI  R30,LOW(0x1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x4:
	CALL _getRX
	MOV  R17,R30
	CPI  R17,13
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x5:
	MOV  R30,R16
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x6:
	MOV  R26,R16
	LDI  R30,LOW(0)
	CALL __EQB12
	MOV  R0,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x7:
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(0)
	ST   X,R30
	CPI  R19,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x8:
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x9:
	STS  _StartF,R30
	STS  _StartF+1,R31
	STS  _StartF+2,R22
	STS  _StartF+3,R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xA:
	__DELAY_USB 16
	SBI  0x8,4
	__DELAY_USB 16
	CBI  0x8,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xB:
	LDS  R26,_StartF
	LDS  R27,_StartF+1
	LDS  R24,_StartF+2
	LDS  R25,_StartF+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xC:
	ST   Y,R30
	STD  Y+1,R31
	LDD  R17,Y+0
	ST   -Y,R17
	JMP  _USART_Transmit


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	ADC  R23,R25
	RET

__LSRD12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	MOVW R22,R24
	BREQ __LSRD12R
__LSRD12L:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRD12L
__LSRD12R:
	RET

__EQB12:
	CP   R30,R26
	LDI  R30,1
	BREQ __EQB12T
	CLR  R30
__EQB12T:
	RET

__GTB12U:
	CP   R30,R26
	LDI  R30,1
	BRLO __GTB12U1
	CLR  R30
__GTB12U1:
	RET

__NEW12:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRNE __NEW12T
	CLR  R30
__NEW12T:
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
