//=============== USART0, ADC ======================

// Time out  USART
void TimeOut(void)
{
  bit_rx0_end = 1;
}

// Get a character from the USART0 Receiver buffer
//     RX,   ,  ==0
char getRX(void)
{
unsigned char data;

if (rx_counter0 !=0)
  {
   data=rx_buffer0[rx_rd_index0++];
   if (rx_rd_index0 == RX_BUFFER_SIZE0) rx_rd_index0=0;
   #asm("cli")
   --rx_counter0;
   #asm("sei")
  }
else data=0;
return data;
}

//   UART
void USART_Transmit( unsigned char data )
{
/* Wait for empty transmit buffer */
while ( !( UCSR0A & (1<<UDRE0)) );
/* Put data into buffer, sends the data */
UDR0 = data;
}

// ============== / ADC ==================
// Read the AD conversion result
//  -     Vref (0 =   Vref)

unsigned int read_adc(unsigned char adc_input, unsigned char adc_vref)
{
ADMUX=(adc_input & 0x1f) | (adc_vref & 0xff);
if (adc_input & 0x20) ADCSRB |= 0x08;
else ADCSRB &= 0xf7;
// Delay needed for the stabilization of the ADC input voltage
delay_us(10);
// Start the AD conversion
ADCSRA|=0x40;
// Wait for the AD conversion to complete
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
}

