/*****************************************************
This program was produced by the
CodeWizardAVR V2.05.0 Professional
Project : vna328
Version : 1.0
Date    : 14.10.2013
Author  : RA4NAL
Company : Home

Chip type               : ATmega328
Program type            : Application
AVR Core Clock frequency: 16,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 512
*****************************************************/
//=================  =====================
#define PORT_DDS PORTC  //  PORTC  DDS
#define FQUP     3      // PORTC.3 connected to AD9851 device select pin
#define WCLK     4      // PORTC.4 connected to AD9851 clock pin
#define D7       5      // PORTC.5 connected to AD9851 D7 (serial data) pin
#define PORT_RLE PORTD  //  PORTD  rele  RESET
#define RESET    2      // PORTD.2 connected to RESET AD9851
#define RELE     3      // PORTD.3 connected to rele
// PC1 - ADC1 - 
// PC2 - ADC2 - 
// AREF
//===================================================
#define PowerDown 0x04  //    Power down AD9851,50
#define Normal 0x01     //     AD9851
//#define Normal 0x00     //     AD9850

#define TimeRX 500      //    USART ~500 
// FTW = (Fout*2^32)180
#define MinFrq 11930470 // FTW  min freq = 0,5 Mhz

#include <mega328.h>
#include <delay.h>
#include <stdio.h>      // Standard Input/Output functions
#include <stdlib.h>     //  
#include <ctype.h>      //  
#include <iobits.h>     // SETBIT, CLRBIT

// ============= Global variables ==============
//    
unsigned char Mode;       //  
unsigned long int StartF; //  
unsigned int NumberF;     // - 
unsigned long int StepF;  //  

bit bit_rx0_end;          //   UART 
bit bit_rx0_error;        //  UART

// USART Receiver buffer
#define RX_BUFFER_SIZE0 32
unsigned char rx_buffer0[RX_BUFFER_SIZE0];
unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;

//  
#include "timers.h"       //  

SoftTimer timer1;         //   

#include "timers.c"       //  
#include "interrupt328.c" // 
#include "usart.c"        // / UART, ADC
#include "decoder.c"      // /    

void main(void)
{
// ================== Local variables ==============
unsigned char Temp;
unsigned int intTemp;
unsigned int adcamp;
unsigned int adcphs;

#include "initSFR328.c"     //  SFR mega328

//  AD9851  serial mode
delay_ms(50);
SETBIT(PORT_RLE,RESET);
delay_us(3);
CLRBIT(PORT_RLE,RESET);
delay_us(3);
SETBIT(PORT_DDS,WCLK);
delay_us(3);
CLRBIT(PORT_DDS,WCLK);
delay_us(3);
SETBIT(PORT_DDS,FQUP);
delay_us(3);
CLRBIT(PORT_DDS,FQUP);
StartF=0;                    //  
Mode=PowerDown;              // 
Load9851();

//   UART
  rx_wr_index0 = 0;
  rx_rd_index0 = 0;
  rx_counter0 = 0;
  bit_rx0_error = 0;         //   
  bit_rx0_end = 0;           //    USART

Temp=UDR0;                   //  UART
Temp=UDR0;                   // -------------

//    UART,    
CreateTimer(&timer1, 0, 0, IDLE, TimeOut);

#asm("sei")                  // Global enable interrupts

// =================   ======================
while (1)
      {
      if (bit_rx0_end == 1)           // time out  
        {
        Temp = DecodeCom ();          //   
//    UART
          #asm("cli")
          rx_wr_index0 = 0;
          rx_rd_index0 = 0;
          rx_counter0 = 0;
          bit_rx0_error = 0;         //   
          bit_rx0_end = 0;           //    USART
          #asm("sei")
        if ((Temp==0) & (NumberF!=0)) //  
          {
          if (Mode == 0) CLRBIT(PORT_RLE,RELE)   // .  . 
            else SETBIT(PORT_RLE,RELE);
//  
          for (intTemp=0; intTemp < NumberF; intTemp++)
            {
             if (StartF > MinFrq)  Mode = Normal;   // F > 0,5 mhz
                else Mode = PowerDown;  // F < 0,5 mhz, Power Down
            Load9851();               //  9851
            delay_us(1000);           //  1000 
            adcamp = read_adc(1,0);   //  , vref
            adcphs = read_adc(2,0);   //  , vref
            Temp = (unsigned char)adcphs; //  
            USART_Transmit(Temp);     // LSB
            adcphs = adcphs>>8;
            Temp = (unsigned char)adcphs;
            USART_Transmit(Temp);     // MSB
            Temp = (unsigned char)adcamp;  //  
            USART_Transmit(Temp);     // LSB
            adcamp = adcamp>>8;
            Temp = (unsigned char)adcamp;
            USART_Transmit(Temp);     // MSB
            StartF = StartF+StepF;    //  
            }
          }
        }
      }
}
