//      
//  15-6/7.
// ()  .
#include <stdio.h>
#include <conio.h>
#include <windows.h>
#include <process.h>
#include <time.h>
#include "porttalk.h"

/*  LPT */
//   (c "_" )
#define _AUTOFEED (unsigned char)(2)
#define _SELECT_INPUT (unsigned char)(8)
#define _STROBE (unsigned char)(1)
#define INIT (unsigned char)(1<<2)
//     LPT2
const unsigned short LPT_PORT = 0x278;
#define CONTROL_PORT LPT_PORT+2
#define LCD_PORT LPT_PORT

/*  LCD */
// 
#define LCD_a (unsigned char)(1<<0)
#define LCD_b (unsigned char)(1<<1)
#define LCD_c (unsigned char)(1<<2)
#define LCD_d (unsigned char)(1<<3)
#define LCD_e (unsigned char)(1<<4)
#define LCD_f (unsigned char)(1<<5)
#define LCD_g (unsigned char)(1<<6)
// 
#define LCD_0 LCD_a|LCD_b|LCD_c|LCD_d|LCD_e|LCD_f
#define LCD_1 LCD_b|LCD_c
#define LCD_2 LCD_a|LCD_b|LCD_g|LCD_e|LCD_d
#define LCD_3 LCD_a|LCD_b|LCD_g|LCD_c|LCD_d
#define LCD_4 LCD_f|LCD_g|LCD_b|LCD_c
#define LCD_5 LCD_a|LCD_f|LCD_g|LCD_c|LCD_d
#define LCD_6 LCD_a|LCD_f|LCD_e|LCD_d|LCD_c|LCD_g
#define LCD_7 LCD_a|LCD_b|LCD_c
#define LCD_8 LCD_a|LCD_b|LCD_c|LCD_d|LCD_e|LCD_f|LCD_g
#define LCD_9 LCD_a|LCD_f|LCD_g|LCD_b|LCD_c|LCD_d
const unsigned char LCD_segments_table[]={LCD_a,LCD_b,LCD_c,LCD_d,LCD_e,LCD_f,LCD_g};
const unsigned char LCD_digits_table[]={LCD_0,LCD_1,LCD_2,LCD_3,LCD_4,LCD_5,LCD_6,LCD_7,LCD_8,LCD_9};

unsigned char LCD_data[6];

//  dig    pos
void LCD_set(char dig, char pos)
{
	//  - 
	if (pos==0)
 	{
		switch (dig)
		{
		case 1: 
			LCD_data[0] = LCD_1;
			break;
		case 2: 
			LCD_data[0] = LCD_a | LCD_b;
			break;
		default:
			LCD_data[0] = 0;
		}
	} else {
		LCD_data[pos]=LCD_digits_table[dig];
	}
}

// 
void LCD_intr()
{
	static unsigned char substr=0;
	unsigned char i, j, n, m;
	
	for(i=0;i<6;i++)
	{
		m = LCD_data[i] ^ substr;
		for(j=0;j<(i==4?8:7);j++)
		{
			if ((i==0)&&(j>2)) break;
			n=m & 1;
			outportb(LCD_PORT,n);
			outportb(LCD_PORT,n | 2);
			m >>= 1;
		}
	}
	substr^=0xFF;
}

volatile char terminated, terminated_ACK;

// 
void __cdecl LCD_thread(void *dummy)
{
	while (!terminated)
	{
		LCD_intr();
		Sleep(100);
	}
	terminated_ACK = 1;
	_endthread();
}

int main(int argc, char *argv[])
{
	char cmd[25],str[255];
	unsigned char d,byte;
	unsigned short port;
	unsigned int cnt,cnt1;
	struct tm *tm_var;
	time_t time_var;
	
	OpenPortTalk();

	//   Visual C++,     .
	//    NT.
	SetConsoleCP(1251);
	SetConsoleOutputCP(1251);
	
	while (1)
	{
		memset(&LCD_data,0,sizeof LCD_data);
		outportb(LCD_PORT,0);
		outportb(CONTROL_PORT,INIT);// INIT  
		printf( "c - , d -   , t -  ,\n"
				"p -      debug, w - ,\n"
				"q -  ( )\n>");
		gets(cmd);
		switch (cmd[0])
		{
		case 'c':		
			puts("     ");
			terminated = 0; terminated_ACK = 0;
			_beginthread(LCD_thread, 0, NULL);
			cnt = 0;
			while(!kbhit())
			{
				cnt1 = cnt;
				for (d=5;d<=5;d--) 
				{
					LCD_set(cnt1 % 10,d);
					cnt1 /= 10;
				}
				printf("%d\r",cnt);
				if (++cnt>2999) cnt=0;
				Sleep(1000);
			}
			terminated = 1;
			puts("    ");
			getch();
			while (!terminated_ACK) Sleep(1);
			break;
		case 'd':		
			puts("  o 000-999  Enter  ");
			terminated = 0; terminated_ACK = 0;
			_beginthread(LCD_thread, 0, NULL);
			while (1)
			{
				printf("d>");
				gets(str);
				if (!strlen(str)) break;
				memset(&LCD_data,0,sizeof LCD_data);
				for (d=0;(d<sizeof LCD_data)&&(d<strlen(str));d++) LCD_set(str[d]-'0',d);
			}
			terminated = 1;
			while (!terminated_ACK) Sleep(1);
			break;
		case 't':
			puts("    <><>,  a1.\n -  .");
			terminated = 0; terminated_ACK = 0;
			_beginthread(LCD_thread, 0, NULL);
			while (1)
			{
				printf("t>");
				gets(str);
				if (!strlen(str)) break;
				LCD_data[str[1]-'0']=LCD_segments_table[str[0]-'a'];
			}
			terminated = 1;
			while (!terminated_ACK) Sleep(1);
			break;
		case 'p':
			puts("/ - i/o <> <> ( HEX).\n -  .");
			while (1)
			{
				printf("p>");
				gets(str);
				if (sscanf(str, "%c %hx %hx", &d, &port, &byte)<3) break;
				switch (d)
				{
				case 'i':
					byte = inportb(port);
					printf("%02hx\n",byte);
					break;
				case 'o':
					outportb(port, byte);
				}
			}
			break;
		case 'w':
			puts("     ");
			terminated = 0; terminated_ACK = 0;
			_beginthread(LCD_thread, 0, NULL);
			cnt = 0;
			while(!kbhit())
			{
				time(&time_var);
				tm_var=localtime(&time_var);
				LCD_set(tm_var->tm_sec % 10, 5);
				LCD_set(tm_var->tm_sec / 10, 4);
				LCD_set(tm_var->tm_min % 10, 3);
				LCD_set(tm_var->tm_min / 10, 2);
				LCD_set(tm_var->tm_hour % 10, 1);
				LCD_set(tm_var->tm_hour / 10, 0);
				Sleep(1000);
			}
			terminated = 1;
			getch();
			while (!terminated_ACK) Sleep(1);
			break;
		default:
			goto quit;
	}
}

quit:
	outportb(CONTROL_PORT,0);		
	ClosePortTalk();
}