#ifndef PortTalk_H
#define PortTalk_H

#ifdef __cplusplus
extern "C" {
#endif

unsigned char OpenPortTalk(void);
void ClosePortTalk(void);

void outportb(unsigned short PortAddress, unsigned char databyte);
void outport(unsigned short PortAddress, unsigned short dataword);
void outportd(unsigned short PortAddress, unsigned long datadword);
unsigned char inportb(unsigned short PortAddress);
unsigned short inport(unsigned short PortAddress);
unsigned long inportd(unsigned short PortAddress);

#define    inp(PortAddress)         inportb(PortAddress)
#define    outp(PortAddress, Value) outportb(PortAddress, Value)
#define    inpw(PortAddress)         inport(PortAddress)
#define    outpw(PortAddress, Value) outport(PortAddress, Value)
#define    inpd(PortAddress)         inportd(PortAddress)
#define    outpd(PortAddress, Value) outportd(PortAddress, Value)

#ifdef __cplusplus
}
#endif

#endif //PortTalk_H