Program BlowIt2051;
{$D Copyright (C) 1996 Silicon Studio}
Uses  VTD;
var
  base: Word;
  i, j, k, l: Integer;
  mem: Array[0..2047] of byte;
  f: file;
Const
  inc_bit    = $01;
  vpp_bit    = $02;
  prog_bit   = $04; { not inverse! }
  erase_bit  = $08;
  prog_mode  = $0F;
  erase_mode = $07;
  idle       = $09; { Idle, RST = 0 }
label
  err_exit;
begin
   Writeln;
   Writeln('----------- BlowIT (tm) 2051 ver 1.0 beta -----------');
   Writeln('http://sistudio.com for schematics and latest release');
   Writeln;

   if ParamCount<1 then begin
      Writeln('usage: BI2051 filename.bin [n]');
      Writeln('usage: n=1,2,3 LPT number to use');
      Writeln;
      halt(1);
   end;
   base := memw[$40:8];
   if ParamStr(2) = '2' then begin
     base := memw[$40:10];
   end;
   if ParamStr(2) = '3' then begin
     base := memw[$40:12];
   end;
   If base = 0 then begin
     Writeln('Parallel port does not exist!');
     Halt(2);
   end;
   for i:=0 to 2047 do mem[i] := $FF;
   assign(f, ParamStr(1));
   reset(f,1);
   blockread(f, mem, 2048,i);
   close(f);
   If IOResult <> 0 then begin
     Writeln('File not found!');
     halt(2); { File error }
   end;

   port[base] := $FF;
   { Erase }
   port[base+2] := $01;
   nms(10);
   port[base+2] := $03;                       { RST = 12 }
   nms(1);
   port[base+2] := erase_mode;                { RST = 12, PROG = H }
   nms(1);
   port[base+2] := erase_mode xor prog_bit;   { P3.2 = 0 }
   nms(12);                                   { This is ERASE PULSE!}
   port[base+2] := erase_mode;                { P3.2 = 1 }
   nms(12);
   port[base+2] := erase_mode xor vpp_bit;    { RST = 0 }
   nms(20);

   { Program ROM }
   port[base+2] := idle;
   nms(10);
   port[base+2] := idle or vpp_bit;
   nms(10);
   port[base+2] := prog_mode;    { RST = 12, PROG = H }
   nms(1);
   Write('Blowing');
   k := 0; l := 0;
   for j := 0 to 2047 do
   begin
      port[base] := mem[j];
      if mem[j] <> $FF then begin

      delay_mks(2);
      { PROG Pulse}
      EnterCriticalSection;
      port[base+2] := prog_mode xor prog_bit; { P3.2 = 0 }
      delay_mks(5);
      port[base+2] := prog_mode; { P3.2 = 1 }
      delay_mks(2);
      i := 0;
      while (port[base+1] and 64) = 0 do
      begin
        delay_mks(10);
        if i>200 then begin
           Writeln;
           Writeln('Error, never ready?');
           goto err_exit;
        end;
        if i > k then k := i;
        inc(i);
      end;
      LeaveCriticalSection;
      if l > 30 then begin
         Writeln;
         Writeln('Error, no device?');
         goto err_exit;
      end;
      if i = 0 then inc(l);
      delay_mks(2);
      end;
      port[base+2] := prog_mode xor inc_bit; { XT1 = 1 }
      delay_mks(5);
      port[base+2] := prog_mode; { XT1 = 1 }
      delay_mks(2);

      if (j mod 64) = 0 then Write('.');
   end;
   port[base] := $FF;  nms(1);
   port[base+2] := prog_mode xor vpp_bit; { P3.2 = 0!! }
   nms(1);
   port[base+2] := idle;
   port[base] := $00;

   Writeln;
   Writeln('We are finished.');
   Halt(0);

err_exit:
   LeaveCriticalSection;
   Halt(1);
end.

