; .       PIC16F84 4    DS18B20
;      ( )   
;( -  )
;  RA3   . .     .
; !!!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
LIST P=16F84
;    
#include <P16F84.INC>
__config  _XT_OSC & _WDT_OFF & _PWRTE_ON
F0		EQU	0
RTIF	equ	2
;  ,  
NumL	EQU	0x0C			
NumH	EQU	0x0D			
Thou	EQU	0x0E			
Hund	EQU	0x0F			
Tens	EQU	0x10			
Ones	EQU	0x11			
I		EQU	0x13
A		EQU	0x14
BACKUPW	EQU	0x15
BACKUPS	EQU	0x16
RAZR0	EQU	0x17						; ,       
RAZR1	EQU 0x18
RAZR2	EQU 0x19
;  FLAGS    :
;0 -    
;1 -    
;2 -         
;3 -     ,     
;4 -    ,     
;5 -         DS1820
;6 -    
FLAGS	EQU 0x1A
J		EQU	0x1B
K		EQU	0x1C
TIME0	EQU	0x1D
TIME1	EQU	0x1E
PA		EQU 0x1F
T7SEG0	EQU	0x20
T7SEG1	EQU	0x21
T7SEG2	EQU	0x22
T_IND	EQU	0x23
TEMP_READH		EQU	0x24
TEMP_READL		EQU	0x25
TL				EQU	0x26
TH				EQU	0x27
TIME2			EQU	0x28
I_BYTE			EQU	0x29
_N				EQU	0x2A
TEMP			EQU	0x2B
O_BYTE			EQU	0x2C
LOOP1			EQU	0x2D
LOOP2			EQU	0x2E
T_ALARM		EQU	0x2F
DT_ALARM		EQU	0x30

CONSTANT 		DATA_PIN=7

;******	     *******
		BSF     STATUS, RP0					;   1 
    	CLRF    TRISA						;         
    	CLRF	TRISB
    	GOTO	BEGIN_PROG	
	
;*****         *************
 		BCF		INTCON,	GIE					; 
		MOVWF	BACKUPW						;   
		MOVF	STATUS, 0					;  STATUS
		MOVWF	BACKUPS

		; 
		INCF	TIME0, 1
		MOVF	TIME0, 0
		SUBLW	.81							;122
		BTFSC	STATUS, C	
		GOTO	L22	
		CLRF	TIME0
		INCF	TIME2, 1
L18		MOVF	TIME2, 0
		SUBLW	.2							;     1 .
		BTFSC	STATUS, C	
		GOTO	L26
		CLRF	TIME2
		BSF		FLAGS, 5
L26		BTFSS	FLAGS, 0					;      
		GOTO	L22							; 
		BTFSS	FLAGS, 1					;    
		GOTO	L22
		BCF		FLAGS, 2
		BSF		FLAGS, 7
		INCF	T_ALARM, 1
		MOVF	T_ALARM, 0
		SUBLW	0x7D						;  125 ,   -55 
		BTFSS	STATUS, Z	
		GOTO	L22
		MOVLW	0xC9
		MOVWF	T_ALARM
		
		;   
L22		BCF		PA, 0					;,  
		BCF		FLAGS, 1					; .
		BCF		PA, 1					; 
		BCF		PA, 2
		BSF		PA, 4
		MOVF	PA, 0
		MOVWF	PORTA
		BSF     STATUS, RP0					;   1
		BSF		TRISB, 5					;  ,      
		BSF		TRISB, 6		
		BCF     STATUS, RP0					;   0
		BTFSC	PORTB, 6					;      
		GOTO	L23
		BSF		FLAGS, 0
		MOVLW	.255
		MOVWF	T_IND
L23		DECFSZ	T_IND
		GOTO	L24
		BCF		FLAGS, 0
		BTFSC	FLAGS, 7
		CALL	SEEPROM
		BCF		FLAGS, 7
L24		BTFSS	PORTB, 5
		BSF		FLAGS, 1
		BSF     STATUS, RP0					;   1
		BCF		TRISB, 5					;  ,      
		BCF		TRISB, 6		
		BCF     STATUS, RP0					;   1
		
		;   RAZR0, RAZR1, RAZR2
		MOVLW	.0							;  0		
		SUBWF	I, 0		
		BTFSS	STATUS, Z
		GOTO	L2	
		MOVLW	B'10000000'
		ANDWF	PORTB, 1					;  ,   
		MOVF	RAZR0, 0
		IORWF	PORTB, 1					;  
		BSF		PA, 0						;   
		MOVF	PA, 0
		MOVWF	PORTA	
		GOTO	L4
L2		MOVLW	.1							;  1
		SUBWF	I, 0		
		BTFSS	STATUS, Z
		GOTO	L3	
		MOVLW	B'10000000'
		ANDWF	PORTB, 1					;  ,   
		MOVF	RAZR1, 0
		IORWF	PORTB, 1					;  
		BSF		PA, 1
		BTFSC	FLAGS, 6
		BCF		PA, 4
		BTFSS	FLAGS, 6
		BSF		PA, 4
		MOVF	PA, 0
		MOVWF	PORTA
		GOTO	L4
L3		MOVLW	B'10000000'
		ANDWF	PORTB, 1					;  ,   
		MOVF	RAZR2, 0
		IORWF	PORTB, 1					;  
		BSF		PA, 2
		MOVF	PA, 0
		MOVWF	PORTA	
L4		INCF	I, 1
		MOVLW	.3							;  ,   3
		SUBWF	I, 0
		BTFSC	STATUS, Z
		CLRF	I

		;    
IRET	BCF 	INTCON, RTIF 		;    
		MOVF	BACKUPS, 0
		MOVWF	STATUS
		MOVF 	BACKUPW, 0			;  
		BSF 	INTCON, GIE			; 
		RETFIE						;   

;******    *****************************
BEGIN_PROG	
		MOVLW	B'01000011'			;      
		MOVWF	OPTION_REG			; 1:16,      
		BCF     STATUS, RP0     	;   0 
		CLRF	PORTB
		MOVLW	B'00000111'
		MOVWF	PA
		MOVF	PA, 0
		MOVWF	PORTA	
		CLRF	I					;   	
		CLRF	FLAGS				;
		CALL	START_DS
		CLRF	TMR0
		CLRF	TEMP_READL
		CLRF	TEMP_READH
		CALL	LEEPROM
		MOVLW	0x02
		MOVWF	DT_ALARM
		CLRF	TIME0
		CLRF	TIME2
		CLRF	TMR0
		MOVLW	B'10100000'			;    
		MOVWF	INTCON
		BCF		FLAGS, 5
		BCF		FLAGS, 3
		MOVLW	B'10111111'             ;(   )
		MOVWF	RAZR0
		MOVWF	RAZR1
		MOVWF	RAZR2
		CALL	START_DS
		;       
L0		BTFSS	FLAGS, 5
		GOTO	L0
		CALL	START_DS
		BCF		FLAGS, 5
L00		BTFSS	FLAGS, 5
		GOTO	L00
		
;******    ******
L10		CLRWDT
L25		BTFSS	FLAGS, 0
		GOTO	L12					;  
		BTFSC	FLAGS, 2
		GOTO	L10
		BSF		FLAGS, 2
		BCF		FLAGS, 6			; 
		BTFSC	T_ALARM, 7			;  
		GOTO	L70					;  
		MOVF	T_ALARM, 0
		MOVWF	NumL
		GOTO	L71		
L70		MOVLW	0xFF
		MOVWF	NumL
		MOVF	T_ALARM, 0
		SUBWF	NumL, 1
L71		CLRF	NumH
		CALL	Convert
		MOVF	Ones, 0
		CALL	DS7SEG
		MOVWF	RAZR0
		MOVF	Tens, 0
		CALL	DS7SEG
		MOVWF	RAZR1
		MOVF	Hund, 0
		CALL	DS7SEG
		MOVWF	RAZR2
		BTFSC	T_ALARM, 7
		BCF		RAZR2, 6			;     		
		GOTO	L10
L12		BCF		FLAGS, 2			; 
		BTFSC	FLAGS, 3
		CALL	CONV_T
		BCF		FLAGS, 3
		BTFSS	FLAGS, 5
		GOTO	L10
		;   
		BCF		FLAGS, 5
		BSF		FLAGS, 3
		CALL	READ_T
		CALL	START_DS
		ANDLW	0xFF
		BTFSS	STATUS, Z
		GOTO	L10
		MOVLW	B'00000001'
		MOVWF	RAZR0
		MOVWF	RAZR1
		MOVWF	RAZR2
		BCF		FLAGS, 3
		GOTO	L10					;   
;****************************************************************************

;     WREG   7-  
DS7SEG	ADDWF	PCL, 1
        RETLW  	B'01000000'			;0
        RETLW  	B'01111001'			;1
        RETLW  	B'00100100'			;2
        RETLW  	B'00110000'			;3
        RETLW  	B'00011001'			;4
        RETLW  	B'00010010'			;5
        RETLW  	B'00000010'			;6
        RETLW  	B'01111000'			;7
        RETLW  	B'00000000'			;8
        RETLW  	B'00010000'			;9
        RETLW  	B'01111111'			;
        RETLW  	B'00111111'			;
	
;*****************************************************************************
;    HEX16 ( NumL, NumH)   BSD
;( Thou, Hund, Tens, Ones) 
Convert swapf   NumH,w			
        IORLW	B'11110000'		
		movwf   Thou
		addwf   Thou, 1
		addlw   0xE2
		movwf   Hund
     	addlw   0x32
     	movwf   Ones
     	movf    NumH, 0
     	andlw   0x0F
     	addwf   Hund, 1
     	addwf   Hund, 1
     	addwf   Ones, 1
     	addlw   0xE9
     	movwf   Tens
     	addwf   Tens, 1
     	addwf   Tens, 1
     	swapf   NumL, 0
     	andlw   0x0F
     	addwf   Tens, 1
     	addwf   Ones, 1
     	rlf     Tens, 1
     	rlf     Ones, 1
     	comf    Ones, 1
     	rlf     Ones, 1
     	movf    NumL, 0
     	andlw   0x0F
     	addwf   Ones, 1
     	rlf     Thou, 1
     	movlw   0x0A
Lb1: 	addwf   Ones, 1
     	decf    Tens, 1
     	btfss   3, 0
     	goto   Lb1
Lb2: 	addwf   Tens, 1
     	decf    Hund, 1
     	btfss   3, 0
     	goto   Lb2
Lb3: 	addwf   Hund, 1
     	decf    Thou, 1
     	btfss   3, 0
     	goto   Lb3
Lb4: 	addwf   Thou, 1
     	btfss   3, 0
     	goto   Lb4
		MOVLW	Thou					;  
		MOVWF	FSR
		MOVLW	3
		MOVWF	I
L54		MOVF	F0, 0
		ANDLW	0x0F
		BTFSS	STATUS, Z
		RETURN							;   0
		MOVLW	0x0A
		MOVWF	F0
		INCF	FSR	
		DECFSZ	I
		GOTO	L54
        RETURN

;      0.1     DS1820
; : TEMP_READH, TEMP_READL,    
CONV_T	MOVF	TEMP_READL, 0
		MOVWF	NumL
		MOVF	TEMP_READH, 0
		MOVWF	NumH
		BTFSC	TEMP_READH, 7			;  
		GOTO	L30				;  
		MOVLW	.4				;       .16d 
		MOVWF	A
L61		BCF		STATUS, C
		RRF		NumH, 1
		RRF		NumL, 1
		DECFSZ	A, 1
		GOTO	L61
		MOVF	NumL, 0
		MOVWF	TH
		MOVF	TEMP_READL, 0			;  
		ANDLW	B'00001111'
		GOTO	L50
L30		MOVLW	.4				;       .16d
		MOVWF	A
L62		BCF		STATUS, C
		RRF		NumH, 1
		RRF		NumL, 1
		DECFSZ	A, 1
		GOTO	L62
		MOVLW	0xFF
		MOVWF	TH
		MOVF	NumL, 0
		SUBWF	TH, 1
		movlw	0xFF
		movwf	NumH
		MOVF	TEMP_READL, 0			;   
		ANDLW	B'00001111'
		SUBWF	NumH, 0
		ANDLW	B'00001111'
L50		MOVWF	NumL
		CLRF	NumH
		MOVLW	.6			
		MOVWF	A
L63		MOVF	NumL, 0
		ADDWF	NumH, 1
		DECFSZ	A, 1
		GOTO	L63
		MOVF	NumH, 0
		MOVWF	NumL				
		CLRF	NumH
		CALL	Convert
		MOVLW	0x0A
		SUBWF	Tens, 0
		BTFSC	STATUS, Z
		CLRF	Tens
		MOVLW	.5						; 
		SUBWF	Ones, 0
		BTFSC	STATUS, C
		INCF	Tens, 1
		MOVF	Tens, 0
		MOVWF	TL
	
   		; 	
   		BTFSC		T_ALARM, 7	;  
   		GOTO		L72		;  ,   
   		MOVF		T_ALARM, 0	;  
   		MOVWF		NumL		;  NumL   
   		MOVLW		.54		; 54,      
   		ADDWF		NumL, 1		;     ( )
   		GOTO		L73		; 	
   L72	MOVLW		0xFF		;     
   		MOVWF		NumL
   		MOVF		T_ALARM, 0
   		SUBWF		NumL, 1
   L73	BTFSC		TEMP_READH, 7	;       
   		GOTO		L74		;  
   		MOVF		TH, 0		;      54, 
   		MOVWF		NumH                    ;     ,
   		MOVLW		.54		;     
   		ADDWF		NumH, 1
   		GOTO		L76		; 
   L74	MOVF		TH ,0		;     
   		MOVWF		NumH
   		BTFSC   	PA, 3		;,   !
   		CALL		L2E		;,  ,    
   		MOVF 		NumH, 0		;    , 
		DECF		NumL, 1
   		SUBWF		NumL, 0		;    	
   		BTFSC		STATUS, C			
   		GOTO		L2A		; 
   L2B	BSF		PA, 3		;   -  
   		MOVF		PA, 0
   		MOVWF		PORTA	
   		GOTO		L31		;  
   L2A    	BTFSC		T_ALARM, 7	;    ,    , 
   		GOTO		L2C		;  ,        0
   		GOTO		L2B		;     
   L2C	BCF		PA, 3		;   -  
   		MOVF		PA, 0
   		MOVWF   	PORTA
   		GOTO		L31		;  
   L76	BTFSC   	PA, 3		;     
   		CALL		L2D		;,   ?  ,   ;
   		MOVF		NumH, 0		;  ,  ,
		DECF		NumL, 1	
   		SUBWF		NumL, 0		
   		BTFSC		STATUS, C	;    		 
   		GOTO		L88
   		BCF		PA, 3				
   		MOVF		PA, 0
   		MOVWF		PORTA	
   		GOTO		L31
   L2D	MOVF		DT_ALARM, 0	; 2 . ,    
   		ADDWF		NumL, 1		; 2 .
   		RETURN
   L2E	MOVF		DT_ALARM, 0	; 2 . ,    
   		SUBWF		NumL, 1		; 2 .,   .
   		RETURN
   L88	BSF		PA, 3
   		MOVF		PA, 0
   		MOVWF		PORTA

		;      
L31		BTFSS	TEMP_READH, 7
		GOTO	L36							;  
		MOVF	TH, 0
		SUBLW	.19
		BTFSC	STATUS, C	
		GOTO	L36							;   19 	
		;   -19.9
		MOVF	TH, 0						;     
		MOVWF	NumL				
		CLRF	NumH
		CALL	Convert
		MOVF	Ones, 0
		CALL	DS7SEG
		MOVWF	RAZR0
		MOVF	Tens, 0
		CALL	DS7SEG
		MOVWF	RAZR1
		MOVLW	0x0A
		CALL	DS7SEG
		MOVWF	RAZR2
		BCF		RAZR2, 6					;     
		BCF		FLAGS, 6					;   
		RETURN
L36		MOVF	TH, 0
		SUBLW	.99
		BTFSC	STATUS, C	
		GOTO	L37							;   99 
		MOVF	TH, 0						;     
		MOVWF	NumL				
		CLRF	NumH
		CALL	Convert
		MOVF	Ones, 0
		CALL	DS7SEG
		MOVWF	RAZR0
		MOVF	Tens, 0
		CALL	DS7SEG
		MOVWF	RAZR1
		MOVF	Hund, 0
		CALL	DS7SEG
		MOVWF	RAZR2
		BCF		FLAGS, 6					;   
		RETURN
		;   -19.9  99.9
L37		MOVF	TL, 0						;     
		MOVWF	NumL				
		CLRF	NumH
		CALL	Convert
		MOVF	Ones, 0
		CALL	DS7SEG
		MOVWF	RAZR0
		MOVF	TH, 0						;     
		MOVWF	NumL				
		CLRF	NumH
		CALL	Convert
		MOVF	Ones, 0
		CALL	DS7SEG
		MOVWF	RAZR1
		MOVF	Tens, 0
		CALL	DS7SEG
		MOVWF	RAZR2
		BTFSC	TEMP_READH, 7				;     
		BCF		RAZR2, 6
		BSF		FLAGS, 6					;   
		RETURN

;       DS1820
READ_T	CALL	INIT
		MOVLW	0xCC						;Skip ROM 
		MOVWF	O_BYTE
		CALL	OUT_BYTE
		MOVLW	0xBE						;Read Scratchpad 
		MOVWF	O_BYTE
		CALL	OUT_BYTE
		; 
		CALL 	IN_BYTE
		MOVWF	TEMP_READL					;0
		CALL 	IN_BYTE
		MOVWF	TEMP_READH					;1
		CALL 	IN_BYTE						;2
		CALL 	IN_BYTE						;3
		CALL 	IN_BYTE						;4
		CALL 	IN_BYTE						;5
		CALL 	IN_BYTE						;6
		CALL 	IN_BYTE						;7
		CALL 	IN_BYTE						;8
		;     
		RETLW	0xFF

;         DS1820
START_DS
		CALL	INIT
		MOVLW	0xCC						;Skip ROM 
		MOVWF	O_BYTE
		CALL	OUT_BYTE
		MOVLW	0x44						;Convert T
		MOVWF	O_BYTE
		CALL	OUT_BYTE
		RETLW	0xFF
		
; The following are common 1-Wire routines used in all applications
INIT:   CALL	PIN_HI
        CALL	PIN_LO
		MOVLW	.50              	; 500 us delay
		CALL 	DELAY_10USEC
		CALL	PIN_HI		  
        MOVLW 	.50					; 500 usec delay
        CALL 	DELAY_10USEC
        RETURN

IN_BYTE:              				; returns byte in W
		MOVLW	.8
		MOVWF	 _N
        CLRF	I_BYTE
IN_BYTE_1:
		CALL PIN_LO					; momentary low on DATA_PIN
        NOP
		CALL PIN_HI
		NOP
		NOP
		NOP
		NOP
		NOP
        NOP
        MOVF	PORTB, W			; 7 usecs later, fetch from DATA_PIN
		MOVWF	TEMP                                                        
		BTFSS	TEMP, DATA_PIN
		BCF STATUS, C				; its a zero
		BTFSC	TEMP, DATA_PIN
		BSF STATUS, C				; its a one
        RRF	I_BYTE, F
		MOVLW .6					; now delay 60 usecs
        CALL	DELAY_10USEC
        DECFSZ	_N, F
        GOTO	IN_BYTE_1
        MOVF	I_BYTE, 0			; return the result in W
        RETURN

OUT_BYTE:
		MOVLW	.8
        MOVWF	_N
OUT_BYTE_1:
		RRF		O_BYTE, F
        BTFSS	STATUS, C
		GOTO	OUT_0
		GOTO	OUT_1	
OUT_BYTE_2:
		DECFSZ	_N, F
        GOTO	OUT_BYTE_1
        RETURN
OUT_0:	CALL	PIN_LO				; bring DATA_PIN low
		MOVLW	.6					; for 60 usecs
		CALL 	DELAY_10USEC
        CALL	PIN_HI
        GOTO	OUT_BYTE_2
OUT_1:	CALL	PIN_LO				; momentary low
        CALL	PIN_HI
        MOVLW 	.6
		CALL 	DELAY_10USEC
        GOTO	OUT_BYTE_2

PIN_HI:	BCF		INTCON,	GIE
		BSF		STATUS, RP0
        BSF		TRISB, DATA_PIN		; high impedance
        BCF		STATUS, RP0
        BSF		INTCON,	GIE
        RETURN
PIN_LO:	BCF		INTCON,	GIE
		BCF		PORTB, DATA_PIN
		BSF		STATUS, RP0
        BCF		TRISB, DATA_PIN		; low impedance zero
        BCF		STATUS, RP0
        BSF		INTCON,	GIE
        RETURN

DELAY_LONG
		MOVLW 	.250				; 250 msec delay
		MOVWF 	LOOP1
DELAY_N_MS:
OUTTER	MOVLW	.110				; close to 1.0 msec delay when set to .110
		MOVWF 	LOOP2
INNER	NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		DECFSZ	LOOP2, F			; decrement and leave result in LOOP2 
		GOTO 	INNER				; skip next statement if zero
		DECFSZ 	LOOP1, F
		GOTO 	OUTTER
		RETURN

DELAY_10USEC:						; provides a delay equal to W * 10 usecs
		MOVWF 	LOOP1
DELAY_100USEC_1:
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		DECFSZ 	LOOP1, F
		GOTO 	DELAY_100USEC_1
		RETURN


;*****************************************************************************
;    T_ALARM
;   
SEEPROM	MOVLW	.50
		MOVWF	EEADR
		MOVF	T_ALARM, 0
		CALL	L21
		RETURN
L21		MOVWF	EEDATA				;  EEROM
		BCF		INTCON, GIE			;  
		BSF     STATUS, RP0			;   1 
		BSF		EECON1, WREN		;   EEROM
		MOVLW	0x55				;    
		MOVWF	EECON2
		MOVLW	0xAA
		MOVWF	EECON2
		BSF		EECON1, WR
L20		NOP							;  
		BTFSC	EECON1, WR
		GOTO	L20
		BCF		EECON1, WREN		;   EEROM
		BCF     STATUS, RP0			;   0
		BSF		INTCON, GIE			;  
		INCF	EEADR, 1
		RETURN

;    T_ALARM
;   
LEEPROM	MOVLW	.50
		MOVWF	EEADR	
		CALL	RROM
		MOVWF	T_ALARM
		RETURN
		;    EEROM
RROM	BSF     STATUS, RP0			;   1 
		BSF		EECON1, RD			;   EEROM	
		BCF     STATUS, RP0			;   0
		INCF	EEADR, 1
		MOVF	EEDATA, 0
		RETURN

		END							; .
